let angle = 0; // sets a global variable for the angle parameter at 0
let resetB; // sets creates global variables for commands that are used further down in the code
let mercuryB;// variables ending in B are for the button function
let venusB;
let earthB;
let marsB;
let jupiterB;
let saturnB;
let uranusB;
let neptuneB;

let mercuryS;//variables ending in S are for the stop function
let venusS;
let earthS;
let marsS;
let jupiterS;
let saturnS;
let uranusS;
let neptuneS;

let mercuryT;// variables ending in T are for the textures
let venusT;
let earthT;
let marsT;
let jupiterT;
let saturnT;
let saturnringT;
let uranusT;
let neptuneT;



function preload(){ //loads textures and sounds before the file is fully loaded so that users dont have to wait for somthing to load once their click a button

  mercuryT    = loadImage("Textures/mercury.jpg") // loads a texture from a file path set in the folder structure and binds is to mercuryT
  venusT      = loadImage("Textures/venus.jpg") // loads a texture from a file path set in the folder structure and binds is to venusT
  earthT      = loadImage("Textures/earth.jpg") // loads a texture from a file path set in the folder structure and binds is to earthT
  marsT       = loadImage("Textures/mars.jpg") // loads a texture from a file path set in the folder structure and binds is to marsT
  jupiterT    = loadImage("Textures/jupiter.jpg") // loads a texture from a file path set in the folder structure and binds is to jupiterT
  saturnT     = loadImage("Textures/saturn.jpg") // loads a texture from a file path set in the folder structure and binds is to saturnT
  saturnringT = loadImage("Textures/saturnring.jpg") // loads a texture from a file path set in the folder structure and binds is to saturnringT
  uranusT     = loadImage("Textures/uranus.jpg") // loads a texture from a file path set in the folder structure and binds is to uranusT
  neptuneT    = loadImage("Textures/neptune.jpg") // loads a texture from a file path set in the folder structure and binds is to neptuneT

  mercuryS    = loadSound("music/Mercury.mp3") //loads a sound from a file path set in the folder structure and binds it to mercuryS
  venusS      = loadSound("music/Venus.mp3") //loads a sound from a file path set in the folder structure and binds it to venusS
  earthS      = loadSound("music/Earth.mp3") //loads a sound from a file path set in the folder structure and binds it to earthS
  marsS       = loadSound("music/Mars.mp3") //loads a sound from a file path set in the folder structure and binds it to marsS
  jupiterS    = loadSound("music/Jupiter.mp3") //loads a sound from a file path set in the folder structure and binds it to jupiterS
  saturnS     = loadSound("music/Saturn.mp3") //loads a sound from a file path set in the folder structure and binds it to saturnS
  uranusS     = loadSound("music/Uranus.mp3") //loads a sound from a file path set in the folder structure and binds it to uranusS
  neptuneS    = loadSound("music/Neptune.mp3") //loads a sound from a file path set in the folder structure and binds it to neptuneS
}


function setup() { // standard setup function used in all javascript code
	createCanvas(1920, 900, WEBGL); //creates the canvas for the digital art using 3d
    //graphics();  was used originally before I discovered the texture feature 
    buttons(); // calls the buttons function
    mousePressed(); //calls the mouse pressed function
    
}

function stop(){//a function designed to stop the music of each planet so that there is no overlap
  mercuryS.stop();//stops the sound of a playing planet once another is playing
  venusS.stop();
  earthS.stop();
  marsS.stop();
  jupiterS.stop();
  saturnS.stop();
  uranusS.stop();
  neptuneS.stop();
}

function draw(){//standard draw function

}

function reset(){ //reset function to make it so that when a button is pressed another canvas is created erasing the previous so that there are no overlapping planets and so that there is no overlapping sounnd
  createCanvas(1920, 900, WEBGL);//creates a canvas of 3d space
  stop();//stops the current music playing
    
}

function mercuryP(){//a function to spawn in a planet 
  reset();//reset function is called a planet spawns so that there is no overlap
  //mercury.background(181,167,167); this feature was used to give the planets basic surfaces relative to their colour before the texture feature was discovered
    directionalLight(255,255,255, -1, 0, -1) // creates a directional light so that the planet can be seen but offset to make it seem like the sun is hitting it 
    noStroke();//removes the lines of the verticies creating the sphere
  texture(mercuryT);//textures the planet
  sphere(200);//creates a sphere
    rotateY(0);//sets the rotation of the Y axis
    rotateX(angle * 1.1); //sets the rotation of the X axis
    rotateZ(angle *1.1);//sets the rotation of the Z axis
    angle += 0.07 //sets the default position of the "angle" parameter localy
    mercuryS.play();//runs the sound of the planet once it is created
}

function venusP(){//a function to spawn in a planet 
  reset();//reset function is called a planet spawns so that there is no overlap
  //venus.background(239,239,239); this feature was used to give the planets basic surfaces relative to their colour before the texture feature was discovered
    directionalLight(255,255,255, -1, 0, -1)// creates a directional light so that the planet can be seen but offset to make it seem like the sun is hitting it 
    noStroke();//removes the lines of the verticies creating the sphere
  texture(venusT);//textures the planet
  sphere(200);//creates a sphere
    rotateY(angle);//sets the rotation of the Y axis
    rotateX(angle * 1.1);//sets the rotation of the X axis
    rotateZ(angle *1.1); //sets the rotation of the Z axis
    angle += 0.07;//sets the default position of the "angle" parameter localy
    venusS.play();//runs the sound of the planet once it is created
}

function earthP(){//a function to spawn in a planet 
  reset();//reset function is called a planet spawns so that there is no overlap
      directionalLight(255,255,255, -1, 0, -1)// creates a directional light so that the planet can be seen but offset to make it seem like the sun is hitting it 
      noStroke();//removes the lines of the verticies creating the sphere
  texture(earthT);//textures the planet
    sphere(200);//creates a sphere
    rotateX(24);//sets the rotation of the X axis
    rotateY(11);//sets the rotation of the Y axis
    angle += 0.7;//sets the default position of the "angle" parameter localy
    earthS.play(); //runs the sound of the planet once it is created
}

function marsP(){//a function to spawn in a planet 
  reset();//reset function is called a planet spawns so that there is no overlap
    directionalLight(255,255,255, -1, 0, -1)// creates a directional light so that the planet can be seen but offset to make it seem like the sun is hitting it 
    noStroke();//removes the lines of the verticies creating the sphere

  texture(marsT);//textures the planet
  sphere(200);//creates a sphere
    rotateY(0);//sets the rotation of the Y axis
    rotateX(angle * 1.1);//sets the rotation of the X axis
    rotateZ(angle *1.1);//sets the rotation of the Z axis
    angle += 0.07;//sets the default position of the "angle" parameter localy
    marsS.play();//runs the sound of the planet once it is created
}

function jupiterP(){//a function to spawn in a planet 
  reset();//reset function is called a planet spawns so that there is no overlap
  //jupiter.background(207,185,151); this feature was used to give the planets basic surfaces relative to their colour before the texture feature was discovered
    directionalLight(255,255,255, -1, 0, -1)// creates a directional light so that the planet can be seen but offset to make it seem like the sun is hitting it 
    noStroke();//removes the lines of the verticies creating the sphere
  texture(jupiterT);//textures the planet
  sphere(200);//creates a sphere
    rotateY(0);//sets the rotation of the Y axis
    rotateX(angle * 1.1);//sets the rotation of the X axis
    rotateZ(angle *1.1);//sets the rotation of the Z axis
    angle += 0.07;//sets the default position of the "angle" parameter localy
    jupiterS.play();//runs the sound of the planet once it is created
}

function saturnP(){//a function to spawn in a planet 
  reset();//reset function is called a planet spawns so that there is no overlap
  //saturn.background(197,171,110); this feature was used to give the planets basic surfaces relative to their colour before the texture feature was discovered
    directionalLight(255,255,255, -1, 0, -1)// creates a directional light so that the planet can be seen but offset to make it seem like the sun is hitting it 
    noStroke();//removes the lines of the verticies creating the sphere
  texture(saturnT);//textures the planet
  sphere(200);//creates a sphere
  
    rotateY(0);//sets the rotation of the Y axis
    rotateX(80);//sets the rotation of the X axis
    angle += 0.07;//sets the default position of the "angle" parameter localy
    saturnRing(); //calls the saturns ring function so saturns ring draws with it
    saturnS.play();//runs the sound of the planet once it is created
}

function saturnRing(){//a function to spawn in saturns ring
  //saturnring.background(123,120,105); this feature was used to give the planets and saturns ring basic surfaces relative to their colour before the texture feature was discovered
    torus(250,10,24,90);//creates a Torus (donut)
      rotateX(80);//sets the rotation of the X axis
      texture(saturnringT);//textures the rings of saturn
}


function uranusP(){//a function to spawn in a planet 
  reset();//reset function is called a planet spawns so that there is no overlap
  //uranus.background(187,225,252); this feature was used to give the planets basic surfaces relative to their colour before the texture feature was discovered
    directionalLight(255,255,255, -1, 0, -1)// creates a directional light so that the planet can be seen but offset to make it seem like the sun is hitting it 
    noStroke();//removes the lines of the verticies creating the sphere
  texture(uranusT);//textures the planet
  sphere(200);//creates a sphere
    rotateY(0);//sets the rotation of the Y axis
    rotateX(angle * 1.1);//sets the rotation of the X axis
    rotateZ(angle *1.1);//sets the rotation of the Z axis
    angle += 0.07;//sets the default position of the "angle" parameter localy
    uranusS.play();//runs the sound of the planet once it is created
}

function neptuneP(){//a function to spawn in a planet 
  reset();//reset function is called a planet spawns so that there is no overlap
  //neptune.background(96,129,255); this feature was used to give the planets basic surfaces relative to their colour before the texture feature was discovered
    directionalLight(255,255,255, -1, 0, -1)// creates a directional light so that the planet can be seen but offset to make it seem like the sun is hitting it 
    noStroke();//removes the lines of the verticies creating the sphere
  texture(neptuneT);//textures the planet
  sphere(200);//creates a sphere
    rotateX(angle * 1.1);//sets the rotation of the X axis
    rotateZ(angle *1.1);//sets the rotation of the Z axis
    angle += 0.07//sets the default position of the "angle" parameter localy
    neptuneS.play();//runs the sound of the planet once it is created
}

function buttons(){ // function to create the buttons needed to spawn the planets
  resetB   = createButton("Reset"); //creates a button for Reset
  mercuryB = createButton("Mercury");//creates a button for Mercury
  venusB   = createButton("Venus");//creates a button for Venus
  earthB   = createButton("Earth");//creates a button for Earth
  marsB    = createButton("Mars");//creates a button for Mars
  jupiterB = createButton("Jupiter"); //creates a button for Jupiter
  saturnB  = createButton("Saturn"); //creates a button for Saturn
  uranusB  = createButton("Uranus"); //creates a button for Uranus
  neptuneB = createButton("Neptune"); //creates a button for Neptune
}

function mousePressed(){ // a function to call when the mouse is pressed on a button which then creates a planet
  resetB.mousePressed(reset); //calls the the Reset function to wipe the canvas when the Reset button is pressed
  mercuryB.mousePressed(mercuryP);//calls the Mercury function to spawn Mercury when the Mercury button is pressed
  venusB.mousePressed(venusP); // calls the Venus function to spawn Venus when the Venus button is pressed
  earthB.mousePressed(earthP); // calls the Earth function to spawn Earth when the Earth button is pressed
  marsB.mousePressed(marsP); // calls the Mars function to spawn Mars when the Mars button is pressed
  jupiterB.mousePressed(jupiterP); // calls the Jupiter function to spawn Jupiter when the Jupiter button is pressed
  saturnB.mousePressed(saturnP); // calls the Saturn function to spawn Saturn when the Saturn button is pressed
  uranusB.mousePressed(uranusP); //calls the Uranus function to spawn Uranus when the Uranus button is pressed
  neptuneB.mousePressed(neptuneP); //calls the Neptune function to spawn Neptune whent the Neptune button is pressed
}

//function graphics(){ // this was a legacy function I used in the early stages to create canvases on the spheres to make them look like planets
  //mercury    = createGraphics(200,200);
  //venus      = createGraphics(200,200);
  //earth      = createGraphics(200,200);
  //mars       = createGraphics(200,200);
  //jupiter    = createGraphics(200,200);
  //saturn     = createGraphics(200,200);
  //saturnring = createGraphics(200,200);
  //uranus     = createGraphics(200,200);
  //neptune    = createGraphics(200,200);
//}